// GetCardHolders.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "GetCardHolders.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGetCardHolders dialog


CGetCardHolders::CGetCardHolders(CWnd* pParent /*=NULL*/)
	: CDialog(CGetCardHolders::IDD, pParent)
{
	//{{AFX_DATA_INIT(CGetCardHolders)
	//}}AFX_DATA_INIT
}
CGetCardHolders ::CGetCardHolders(IApplication *pApp):CDialog(CGetCardHolders::IDD, NULL)
{
	pApplication = pApp;
	//pCardHolder.CreateInstance(__uuidof(CardHolder));
	
}

void CGetCardHolders::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGetCardHolders)
	DDX_Control(pDX, IDC_ACCOUNT, m_CtlAccount);
	DDX_Control(pDX, IDC_ACCOUNTLIST, m_AcctList);
	DDX_Control(pDX, IDC_SUBACCTLIST, m_SubAcctList);
	DDX_Control(pDX, IDC_EXTREFID, m_CtlExtRefID);
	DDX_Control(pDX, IDC_EXTREFIDLIST, m_CtlExtRefIDList);
	DDX_Control(pDX, IDC_GETCHS_WITHEXTREFID, m_GetCHs);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGetCardHolders, CDialog)
	//{{AFX_MSG_MAP(CGetCardHolders)
	ON_CBN_SELCHANGE(IDC_ACCOUNTLIST, OnSelchangeAccountlist)
	ON_CBN_SELCHANGE(IDC_SUBACCTLIST, OnSelchangeSubAccountlist)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGetCardHolders message handlers
BOOL CGetCardHolders::OnInitDialog() 
{
	CDialog::OnInitDialog();
	LoadcolumnHeaders();
	LoadAccounts();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE

}
void CGetCardHolders ::LoadcolumnHeaders()
{
	m_GetCHs.InsertColumn(0,_T("Account"),LVCFMT_LEFT,100);
	m_GetCHs.InsertColumn(1,_T("CHID"),LVCFMT_LEFT,100);
	m_GetCHs.InsertColumn(2,_T("First Name"),LVCFMT_LEFT,200);
	m_GetCHs.InsertColumn(3,_T("Las tName"),LVCFMT_LEFT,200);

}
void CGetCardHolders :: LoadAccounts()
{
		_variant_t vAccounts;
		vAccounts.Clear();
		pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
		
		if(vAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0 ;
		IAccount *pAccount = NULL;
		
		COleSafeArray sa(vAccounts);
		sa.GetUBound(1,&uBound);
		UpdateData(TRUE);
		for(long i =0 ;i <= uBound ; i++)
			
		{
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
			if (pAccount != NULL)
			{
				CString sAcctid;
				sAcctid.Format(L"%ld",pAccount->AccountID);
				m_AcctList.AddString(sAcctid);
				pAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	//m_AcctList.SetCurSel(0);
}

void CGetCardHolders :: LoadSubAccounts()
{
		_variant_t vSubAccounts;
		vSubAccounts.Clear();
				
		//select AccountID
		int index_Acct = m_AcctList.GetCurSel();		
		long lAccountID = m_AcctList.GetItemData(index_Acct);	

		if(lAccountID <= 0)
		{
			AfxMessageBox(L"Select Account!");
			return;
		}
		pApplication->GetSubAccountsByAccountID(lAccountID, &vSubAccounts); // get account details in WP-CS database server
		
		if(vSubAccounts.vt ==  VT_EMPTY)
		{
			return;
		}
		
		long uBound =0, lBound ;
		IAccount *pSubAccount= NULL;
		
		COleSafeArray sa(vSubAccounts);
		sa.GetUBound(1,&uBound);
		sa.GetLBound(1,&lBound);
		UpdateData(TRUE);
		for(long i =lBound ;i <= uBound ; i++)		
		{			
			IDispatch *pDisp = NULL;
			sa.GetElement(&i,(void*)&pDisp);
			HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pSubAccount);
			if (pSubAccount!= NULL)
			{				
				m_SubAcctList.SetItemData(m_SubAcctList.AddString(pSubAccount->AccountName), pSubAccount->AccountID);
				pSubAccount->Release();
			}
			pDisp->Release();
		}
	UpdateData(FALSE);
	
	//m_AccountList.SetCurSel(0);
	
}

void CGetCardHolders::LoadCardHolders()
{
	int index = m_AcctList.GetCurSel();
	CString sAcctName;
	m_AcctList.GetLBText(index,sAcctName);
	BSTR bstrAcctName = sAcctName.AllocSysString();

	
		//select sub account name 
		int indexSub = m_SubAcctList.GetCurSel();
		CString sSubAcctName;
		m_SubAcctList.GetLBText(indexSub,sSubAcctName);
		BSTR bstrSubAcctName = sSubAcctName.AllocSysString();


	_variant_t vCHs;
	vCHs.Clear();
	pApplication->GetCardHoldersByAccountName(bstrAcctName, bstrSubAcctName, &vCHs); // get card holder details of particular account  in WP-CS database server
	
	if(vCHs.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	ICardHolder *pCH = NULL;
	
	COleSafeArray sa(vCHs);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)	
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_ICardHolder,(void**)&pCH);
		if (pCH != NULL)
		{
			int iCol =0;
			int nListViewCounter = m_GetCHs.GetItemCount();
			CString sAcctName, sCHID, sFName, sLName;
			sAcctName = (LPCSTR) pCH->AccountName;
			sCHID.Format(_T("%ld"),pCH->CardHolderID);
			sFName = (LPCSTR) pCH->FirstName;
			sLName = (LPCSTR) pCH->LastName;
			m_GetCHs.SetItemText(nListViewCounter, iCol++, sAcctName);
			m_GetCHs.SetItemText(nListViewCounter, iCol++, sCHID);
			m_GetCHs.SetItemText(nListViewCounter, iCol++, sFName);
			m_GetCHs.SetItemText(nListViewCounter, iCol++, sLName);
			m_GetCHs.SetItemText(nListViewCounter, iCol++, sAcctName);
			pCH->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CGetCardHolders::OnSelchangeAccountlist() 
{
	m_GetCHs.DeleteAllItems();
	m_CtlExtRefIDList.ResetContent();
	LoadSubAccounts();
}

void CGetCardHolders::OnSelchangeSubAccountlist() 
{
	m_GetCHs.DeleteAllItems();
	m_CtlExtRefIDList.ResetContent();
	LoadCardHolders();
}
